/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.
	

	$Id: pgpInactivity.h,v 1.1 1999/09/14 19:10:55 cpeterson Exp $
____________________________________________________________________________*/

#ifndef _pgpInactivity_h
#define _pgpInactivity_h

typedef struct _INACTIVITYTIMER {
	struct _INACTIVITYTIMER*	ptimerNext;
	ULONG						ulFlags;
	LONG						lTimeoutSeconds;
	LONG						lSecondsRemaining;
	PGPInactivityCallbackFunc	callback;
	ULONG						ulUserValue;
} PGPINACTIVITYTIMER, *PPGPINACTIVITYTIMER;

typedef struct {
	PPGPINACTIVITYTIMER		ptimerFirst;
} PGPINACTIVITY, *PPGPINACTIVITY;


VOID
pgpProcessInactivityTimerEvent (
	IN PPGPINACTIVITY		ppi,
	IN PVOID				pCriticalSection);

VOID
pgpInitInactivity (
	IN PPGPINACTIVITY		ppi);

VOID
pgpInactivityProcessOperation (
	IN PPGPINACTIVITY		ppi,
	IN PPGPINACTIVITYSTRUCT	ppcs,
	IN PVOID				pCriticalSection);

VOID
pgpProcessActivityEvent (
	IN PPGPINACTIVITY		ppi,
	IN PVOID				pCriticalSection);

#endif //_pgpInactivity_h